#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAXN 1000005

typedef struct {
    long long x;
    long long h;
    int ind;
} Jarbol;

Jarbol a[MAXN];
double res[MAXN];

int cmp(const void *p, const void *q) {
    Jarbol *A = (Jarbol*)p;
    Jarbol *B = (Jarbol*)q;
    if (A->x < B->x) return -1;
    if (A->x > B->x) return 1;
    return 0;
}

double dist_ll(long long x1, long long y1, double x2, double y2) {
    double dx = x2 - (double)x1;
    double dy = y2 - (double)y1;
    return sqrt(dx*dx + dy*dy);
}

int main() {
    int n, i;
    if (scanf("%d", &n) != 1) return 0;
    for (i = 0; i < n; i++) {
        scanf("%lld", &a[i].x);
        a[i].ind = i;
    }
    for (i = 0; i < n; i++) scanf("%lld", &a[i].h);

    for (i = 0; i < n; i++) res[i] = 1e100;

    qsort(a, n, sizeof(Jarbol), cmp);

    for (i = 0; i < n; i++) {
        if (i > 0) {
            if (a[i-1].h >= a[i].h) {
                double d = dist_ll(a[i].x, a[i].h, (double)a[i-1].x, (double)a[i-1].h);
                if (d < res[a[i].ind]) res[a[i].ind] = d;
            }
        }
        if (i + 1 < n) {
            if (a[i+1].h >= a[i].h) {
                double d = dist_ll(a[i].x, a[i].h, (double)a[i+1].x, (double)a[i+1].h);
                if (d < res[a[i].ind]) res[a[i].ind] = d;
            }
        }
    }

    for (i = 0; i + 1 < n; i++) {
        double xm = (a[i].x + a[i].h + a[i+1].x - a[i+1].h) * 0.5;
        if (xm < a[i].x) xm = a[i].x;
        if (xm > a[i+1].x) xm = a[i+1].x;
        double ym = (double)a[i].h - (xm - (double)a[i].x);
        if (ym >= a[i].h) {
            double d = dist_ll(a[i].x, a[i].h, xm, ym);
            if (d < res[a[i].ind]) res[a[i].ind] = d;
        }
        if (ym >= a[i+1].h) {
            double d = dist_ll(a[i+1].x, a[i+1].h, xm, ym);
            if (d < res[a[i+1].ind]) res[a[i+1].ind] = d;
        }
    }

    for (i = 0; i < n; i++) {
        if (res[i] > 1e50) printf("-1\n");
        else printf("%.6f\n", res[i]);
    }

    return 0;
}